/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.cooking;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.init.ModRecipeSerializers;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.CookerTileEntity;
import dev.toma.gunsrpg.resource.cooking.IBurningRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CookingRecipe
implements IRecipe<CookerTileEntity>,
IBurningRecipe {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack result;
    private final float experience;
    private final int cookTime;

    public CookingRecipe(ResourceLocation id, Item input, ItemStack result, float experience, int cookTime) {
        this.id = id;
        this.input = new ItemStack((IItemProvider)input);
        this.result = result;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    @Override
    public ItemStack[] getInputStacks() {
        return new ItemStack[]{this.input};
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public boolean matches(CookerTileEntity cooker, World level) {
        ItemStack candidate = cooker.func_70301_a(0);
        return this.input.func_77969_a(candidate);
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack assemble(CookerTileEntity cooker) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.COOKING_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.COOKING_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CookingRecipe> {
        public CookingRecipe fromJson(ResourceLocation id, JsonObject object) {
            Item in = this.getItem(JSONUtils.func_151200_h((JsonObject)object, (String)"input"));
            JsonObject outJson = JSONUtils.func_152754_s((JsonObject)object, (String)"output");
            ItemStack result = this.itemFromJson(outJson);
            int cookTime = JSONUtils.func_151208_a((JsonObject)object, (String)"cookTime", (int)200);
            float exp = JSONUtils.func_151221_a((JsonObject)object, (String)"exp", (float)0.0f);
            return new CookingRecipe(id, in, result, exp, cookTime);
        }

        @Nullable
        public CookingRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            ResourceLocation inId = buffer.func_192575_l();
            Item in = (Item)ForgeRegistries.ITEMS.getValue(inId);
            ItemStack out = buffer.func_150791_c();
            int cooktime = buffer.readInt();
            float exp = buffer.readFloat();
            return new CookingRecipe(id, in.getItem(), out, exp, cooktime);
        }

        public void toNetwork(PacketBuffer buffer, CookingRecipe recipe) {
            buffer.func_192572_a(recipe.input.func_77973_b().getRegistryName());
            buffer.func_150788_a(recipe.result);
            buffer.writeInt(recipe.cookTime);
            buffer.writeFloat(recipe.experience);
        }

        private ItemStack itemFromJson(JsonObject object) {
            String itemId = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
            Item item = this.getItem(itemId);
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            if (count < 1 || count > 64) {
                throw new JsonSyntaxException("Invalid item count! Count must be from <1; 64> interval");
            }
            return new ItemStack((IItemProvider)item, count);
        }

        private Item getItem(String itemId) {
            ResourceLocation location = new ResourceLocation(itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item == Items.field_190931_a) {
                throw new JsonSyntaxException("Unknown item: " + itemId);
            }
            return item;
        }
    }
}

